/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst;

import com.bdlington.Catalyst.CatalystAddon;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.GuiThemes;
import meteordevelopment.meteorclient.gui.WindowScreen;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WHorizontalList;
import meteordevelopment.meteorclient.utils.network.Http;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class MyScreen
extends WindowScreen {
    private int latestVersion = -1;
    private boolean isVersionFetched = false;
    private static boolean hasCheckedThisSession = false;

    public MyScreen(GuiTheme theme) {
        super(theme, "Version Check");
        this.fetchLatestVersion();
    }

    public static void checkVersionOnServerJoin() {
        if (hasCheckedThisSession) {
            return;
        }
        hasCheckedThisSession = true;
        MeteorExecutor.execute(() -> {
            try {
                int latestVersion;
                String versionString = Http.get((String)"https://Catalystclient.com/versions/normal1.21.5.txt").sendString();
                if (versionString != null && !versionString.isEmpty() && (latestVersion = Integer.parseInt(versionString.trim())) > CatalystAddon.VERSION) {
                    class_310.method_1551().execute(() -> class_310.method_1551().method_1507((class_437)new MyScreen(GuiThemes.get())));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void resetSessionCheck() {
        hasCheckedThisSession = false;
    }

    public void initWidgets() {
        this.buildUI();
    }

    private void fetchLatestVersion() {
        MeteorExecutor.execute(() -> {
            try {
                String versionString = Http.get((String)"https://Catalystclient.com/versions/normal1.21.5.txt").sendString();
                this.latestVersion = versionString != null && !versionString.isEmpty() ? Integer.parseInt(versionString.trim()) : CatalystAddon.VERSION;
                this.isVersionFetched = true;
                this.reload();
            }
            catch (Exception e) {
                this.latestVersion = CatalystAddon.VERSION;
                this.isVersionFetched = true;
                this.reload();
            }
        });
    }

    private void buildUI() {
        this.addWrappedMessage("Welcome");
        this.add((WWidget)this.theme.horizontalSeparator()).padVertical(this.theme.scale(4.0)).expandX();
        this.addMessage(String.format("Installed Version: %d", CatalystAddon.VERSION));
        if (this.isVersionFetched) {
            this.addMessage(String.format("Latest Version: %d", this.latestVersion));
        } else {
            this.addMessage("Latest Version: Checking...");
        }
        this.add((WWidget)this.theme.horizontalSeparator()).padVertical(this.theme.scale(8.0)).expandX();
        if (this.isVersionFetched && this.latestVersion > CatalystAddon.VERSION) {
            this.addWrappedMessage("You're using the latest Catalyst");
        } else if (this.isVersionFetched && this.latestVersion == CatalystAddon.VERSION) {
            this.addWrappedMessage("You're using the latest Catalyst");
        } else {
            this.addWrappedMessage("Checking for updates");
        }
        this.add((WWidget)this.theme.horizontalSeparator()).padVertical(this.theme.scale(8.0)).expandX();
    }

    private void addMessage(String message) {
        WHorizontalList l = (WHorizontalList)this.add((WWidget)this.theme.horizontalList()).expandX().widget();
        l.add((WWidget)this.theme.label(message)).expandX();
    }

    private void addWrappedMessage(String message) {
        String[] words = message.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > 60 && currentLine.length() > 0) {
                this.addMessage(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            this.addMessage(currentLine.toString());
        }
    }
}

